--//////////////////////////////////////////////////////////////////////////////////////////////////////
/*

*/
--//////////////////////////////////////////////////////////////////////////////////////////////////////
macroScript CreateDefaultProject
	category:~CREATE_DEFAULT_PROJECT_CATEGORY~
	internalCategory:"Tools" 
	tooltip:~CREATE_DEFAULT_PROJECT_TOOLTIP~
	ButtonText:~CREATE_DEFAULT_PROJECT_BUTTONTEXT~
	iconName: "MainUI/CreateDefaultProject" --LOC_NOTES: do not localize this
(
	On Execute Do	
	(
		selectedFolderAbsolutePath = getSavePath initialDir:(pathconfig.getCurrentProjectFolder())
		
		--user selected a valid folder
		if ((selectedFolderAbsolutePath != undefined) and (selectedFolderAbsolutePath != "")) then  
		(
			if(pathconfig.IsProjectFolder(selectedFolderAbsolutePath) )then 
			(
				messagebox (~FOLDER_CONTAINS_EXISTING_PROJECT_CAPTION~) title:~CREATE_DEFAULT_PROJECT_TITLE~ beep:false
			)
			else
			(		
				-- backup the current config paths settings 
				pathconfig.SaveTo(pathconfig.getCurrentProjectFolderPath())
				
				pathconfig.setCurrentProjectFolder selectedFolderAbsolutePath
				
				setdir #autoback ".\\autoback"
				setdir #scene ".\\scenes"
				setdir #import ".\\import"
				setdir #export ".\\export"
				setdir #expression ".\\express"
				setdir #preview ".\\previews"
				setdir #image ".\\sceneassets\\images"
				setdir #sound ".\\sceneassets\\sounds"
				setdir #vpost ".\\vpost"
				setdir #matlib ".\\materiallibraries"
				setdir #renderassets ".\\sceneassets\\renderassets"
				setdir #renderoutput ".\\renderoutput"
				setdir #renderPresets ".\\renderPresets"
				setdir #animations ".\\sceneassets\\animations"
				setdir #archives ".\\archives"
				setdir #photometric ".\\sceneassets\\photometric"
				setdir #downloads ".\\downloads"
				setdir #proxies ".\\proxies"
				setdir #maxstart ".\\scenes"
				setdir #cfd ".\\sceneassets\\CFD"
				
				-- create project folder hierarchy
				dirCount = pathconfig.getProjectSubDirectoryCount()
				for i = 1 to dirCount do
				(
					dir = pathconfig.getProjectSubDirectory i
					dir = pathconfig.convertPathToAbsolute dir
					makedir dir all:true
				)
				
				--Add MapPaths
				mapPathsCount = mapPaths.count()
				for i = 1 to mapPathsCount do
				(
					mapPaths.delete 1
				)
				
				mapsPath = getdir #maxroot
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\glare")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\adskMtl")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\Noise")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\Substance\\noises")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\Substance\\textures")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\mental_mill")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\Particle Flow Presets")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\fx")
				
				downloadsPath = getdir #downloads
				downloadsPath = pathconfig.convertPathToRelativeTo downloadsPath selectedFolderAbsolutePath
				mapPaths.add downloadsPath
				
				-- add XRefs Paths
				xrefPathsCount = xrefPaths.count()
				for i = 1 to xrefPathsCount do
				(
					xrefPaths.delete 1
				)
				
				scenesPath = getdir #scene
				scenesPath = pathconfig.convertPathToRelativeTo scenesPath selectedFolderAbsolutePath
				xrefPaths.add scenesPath
					
				-- save new config paths settings in <rootProjectFolderName>.mxp
				mxpFileName = pathconfig.stripPathToLeaf(selectedFolderAbsolutePath) + ".mxp"
				pathconfig.SaveTo(pathconfig.appendpath selectedFolderAbsolutePath mxpFileName)	
			)	
		)
	)
)
	
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCQ5qJlUKFvzQ8ufI8/dvGsdPOwmYIOgZ9N
-- wG/1yhyZgKLlC//gbmGEHPNu8GymOA02gdEt93pLSa/GhsVAm0A+0V2RdAQvAPQ4
-- 1T1aBHttyOZxcLFDFhxGM9y82KrWJXUjEiE8hLkHtcZyobN5x9+hFl7nOqrBGOEf
-- e1NJ0NXM5wpFgRcXvbAA1SvUeA8uUMUbFMHwjUqki4s8WqX7t7HGV5CMSr6GRXIv
-- WxiGYIEg2RuYv0gbLlc707j/xDEGOradxZP3K/QmWUT5K5R2s64fm6WlZbG81jbL
-- 0zFpOrAGrayOGisUIP1AbblDLxS13jAJg6omOHC1BBMahzCMq/G/
-- -----END-SIGNATURE-----